﻿//////////////////////////////////////////////
// ObjEncoder.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

#include "../Data/DecodedData.h"

#include "ObjDecodeOptions.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ObjEncoder final
	{
		public :

			// Decoding
			static bool canDecode (nkMemory::BufferView<> sources) ;
			static DecodedData decode (nkMemory::BufferView<> sources, const ObjDecodeOptions& options = ObjDecodeOptions()) ;
	} ;
}